/*
 * Decompiled with CFR 0.152.
 */
package com.android.core.domain.model;

import com.utility.ConvertStr;
import java.util.Map;

public class BaseError {
    private String entityId = "";
    private String message = "";
    private String errorCode;
    private Map<String, Object> additionalInfo;

    public BaseError setEntityId(String entityId) {
        this.entityId = entityId;
        return this;
    }

    public BaseError setMessage(String message) {
        this.message = message;
        return this;
    }

    public BaseError setErrorCode(String errorCode) {
        this.errorCode = errorCode;
        return this;
    }

    public BaseError addToEntityId(String entityId) {
        if (ConvertStr.isNullOrEmpty((String)entityId)) {
            return this;
        }
        if (!this.entityId.isEmpty()) {
            this.entityId = this.entityId + ",";
        }
        this.entityId = this.entityId + entityId;
        return this;
    }

    public void addToMessage(BaseError additionalError) {
        if (ConvertStr.isNullOrEmpty((String)additionalError.getEntityId())) {
            return;
        }
        if (!this.message.isEmpty()) {
            this.message = this.message + "\n";
        }
        this.message = this.message + "\u0634\u0645\u0627\u0631\u0647 " + additionalError.getEntityId() + ", \u06a9\u062f \u062e\u0637\u0627(" + additionalError.getErrorCode() + ") \n" + additionalError.getMessage();
    }

    public String getEntityId() {
        return this.entityId;
    }

    public String getMessage() {
        return this.message;
    }

    public String getErrorCode() {
        return this.errorCode;
    }

    public Map<String, Object> getAdditionalInfo() {
        return this.additionalInfo;
    }

    public String toString() {
        return "BaseError(entityId=" + this.getEntityId() + ", message=" + this.getMessage() + ", errorCode=" + this.getErrorCode() + ", additionalInfo=" + this.getAdditionalInfo() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BaseError)) {
            return false;
        }
        BaseError other = (BaseError)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$entityId = this.getEntityId();
        String other$entityId = other.getEntityId();
        if (this$entityId == null ? other$entityId != null : !this$entityId.equals(other$entityId)) {
            return false;
        }
        String this$message = this.getMessage();
        String other$message = other.getMessage();
        if (this$message == null ? other$message != null : !this$message.equals(other$message)) {
            return false;
        }
        String this$errorCode = this.getErrorCode();
        String other$errorCode = other.getErrorCode();
        if (this$errorCode == null ? other$errorCode != null : !this$errorCode.equals(other$errorCode)) {
            return false;
        }
        Map this$additionalInfo = this.getAdditionalInfo();
        Map other$additionalInfo = other.getAdditionalInfo();
        return !(this$additionalInfo == null ? other$additionalInfo != null : !((Object)this$additionalInfo).equals(other$additionalInfo));
    }

    protected boolean canEqual(Object other) {
        return other instanceof BaseError;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $entityId = this.getEntityId();
        result = result * 59 + ($entityId == null ? 43 : $entityId.hashCode());
        String $message = this.getMessage();
        result = result * 59 + ($message == null ? 43 : $message.hashCode());
        String $errorCode = this.getErrorCode();
        result = result * 59 + ($errorCode == null ? 43 : $errorCode.hashCode());
        Map $additionalInfo = this.getAdditionalInfo();
        result = result * 59 + ($additionalInfo == null ? 43 : ((Object)$additionalInfo).hashCode());
        return result;
    }

    public void setAdditionalInfo(Map<String, Object> additionalInfo) {
        this.additionalInfo = additionalInfo;
    }
}

